IF NOT OBJECT_ID('P_EST_ORC_ANALISE') IS NULL
	BEGIN
			DROP PROCEDURE P_EST_ORC_ANALISE
	END
GO
--EXEC P_EST_ORC_ANALISE 1,'22','2018-01-09','2018-01-09'
CREATE PROCEDURE P_EST_ORC_ANALISE (@CD_EMP INT, 
								    @CD_FILIAL VARCHAR(MAX),
									@DT_INI DATETIME, 
									@DT_FIM DATETIME)
AS
SET NOCOUNT ON;
CREATE TABLE #RsVendasOrcamento (CD_EMP INT,
								 CD_FILIAL INT,
								 CD_ORC INT,
								 CD_CLI INT,
								 DT_EMI DATETIME,
								 NM_CLI VARCHAR(200),
								 NR_ECF INT,
								 CD_CX INT,
								 CD_IT INT,
								 CD_PROD INT,
								 DS_PROD VARCHAR(200),
								 NM_FABRIC VARCHAR(200),
								 DS_ARV_MERC_CATEG VARCHAR(200),
								 DS_ARV_MERC_DEPTO VARCHAR(200),
								 DS_ARV_MERC_LINHA VARCHAR(200),
								 DS_ARV_MERC_FAMILIA VARCHAR(200),
								 CD_VEND INT,
								 NM_FUN_VEND VARCHAR(200),
								 DS_CARGO_VEND VARCHAR(200),
								 CD_VEND_LIB INT,
								 NM_FUN_LIB VARCHAR(200),
								 DS_CARGO_LIB VARCHAR(200),
								 CD_VEND_VERBA INT,
								 NM_FUN_VERBA VARCHAR(200),
								 DS_CARGO_VERBA VARCHAR(200),
								 QT_IT MONEY,
								 VLR_TOT_BRUTO MONEY,
								 VLR_TOT_IT MONEY,
								 VLR_DESC MONEY,
								 PERC_DESC MONEY,
								 VLR_DESC_VERBA MONEY,
								 PERC_DESC_VERBA MONEY,
								 PERC_DESC_MIN MONEY,
								 NM_CONCORRENTE VARCHAR(200),
								 VLR_ITEM_CONCORRENTE MONEY,
								 PERC_DESC_CONCORRENTE MONEY)
Declare @sCmd Varchar(5000)
CREATE TABLE #RsFilial (CD_EMP INT,
						CD_FILIAL INT)

set @sCmd ='insert into #RsFilial 
			SELECT 
				CD_EMP,
				CD_filial
			FROM 
				PRC_FILIAL 
			WHERE
				CD_EMP= ' + convert(varchar, @CD_EMP) + '
				AND STS_FILIAL =0
				AND CD_FILIAL IN ( ' + @CD_FILIAL + ')'

exec (@sCmd);

INSERT INTO #RsVendasOrcamento
SELECT
	EST_ORC_CPL.CD_EMP,
	EST_ORC_CPL.CD_FILIAL, 
	EST_ORC_CPL.CD_ORC,
	EST_ORC.CD_CLI,
	EST_ORC.DT_EMI,
	NM_FANT,
	0 AS NR_ECF,
	0 AS CD_CX,
	EST_ORC_CPL.CD_IT,
	EST_ORC_CPL.CD_PROD,
	V_EST_PROD_ARV_MERCADOLOGICA.DS_PROD,
	V_EST_PROD_ARV_MERCADOLOGICA.NM_FABRIC,
	V_EST_PROD_ARV_MERCADOLOGICA.DS_ARV_MERC_CATEG,
	V_EST_PROD_ARV_MERCADOLOGICA.DS_ARV_MERC_DEPTO,
	V_EST_PROD_ARV_MERCADOLOGICA.DS_ARV_MERC_LINHA,
	V_EST_PROD_ARV_MERCADOLOGICA.DS_ARV_MERC_FAMILIA,
	EST_ORC_CPL.CD_VEND,
	FP_FUNC.NM_FUN AS NM_FUN_VEND,
	DS_CARGO,
	EST_ORC_CPL.CD_VEND_LIB,
	'' AS NM_FUN_LIB,
	'' AS DS_CARGO_LIB,
	EST_ORC_CPL.CD_VEND_VERBA,
	'' AS NM_FUN_VERBA,
	'' AS DS_CARGO_VERBA,
	EST_ORC_CPL.QT,
	(EST_ORC_CPL.VLR_IT*EST_ORC_CPL.QT) AS VLR_TOT_BRUTO,
	EST_ORC_CPL.VLR_TOT_IT,
	EST_ORC_CPL.VLR_DESC,
	EST_ORC_CPL.PERC_DESC,
	EST_ORC_CPL.VLR_DESC_VERBA,
	EST_ORC_CPL.PERC_DESC_VERBA,
	EST_ORC_CPL.PERC_DESC_MIN,
	'',
	0,
	0
from
	EST_ORC_CPL INNER JOIN EST_ORC ON
	EST_ORC_CPL.CD_EMP = EST_ORC.CD_EMP AND
	EST_ORC_CPL.CD_FILIAL = EST_ORC.CD_FILIAL AND
	EST_ORC_CPL.CD_ORC = EST_ORC.CD_ORC 
	INNER JOIN V_EST_PROD_ARV_MERCADOLOGICA ON
	EST_ORC_CPL.CD_EMP = V_EST_PROD_ARV_MERCADOLOGICA.CD_EMP AND
	EST_ORC_CPL.CD_PROD = V_EST_PROD_ARV_MERCADOLOGICA.CD_PROD
	INNER JOIN RC_CLI ON
	EST_ORC.CD_EMP = RC_CLI.CD_EMP AND
	EST_ORC.CD_CLI = RC_CLI.CD_CLI
	INNER JOIN FP_FUNC ON
	EST_ORC_CPL.CD_EMP = FP_FUNC.CD_EMP AND
	EST_ORC_CPL.CD_VEND = FP_FUNC.CD_FUN 
	INNER JOIN FP_CARGO ON 
	FP_FUNC.CD_EMP = FP_CARGO.CD_EMP AND
	FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
	INNER JOIN #RsFilial f ON
	EST_ORC_CPL.CD_EMP = f.CD_EMP AND
	EST_ORC_CPL.CD_FILIAL = f.CD_FILIAL 
WHERE
	EST_ORC.DT_EMI BETWEEN @DT_INI AND @DT_FIM

UPDATE
	O
SET 
	O.PERC_DESC_VERBA = (VLR_DESC_VERBA /(VLR_TOT_BRUTO/QT_IT)) * 100
FROM
	#RSVENDASORCAMENTO O 
WHERE
	O.VLR_DESC_VERBA > 0
	AND O.PERC_DESC_VERBA=0


UPDATE
	O
SET 
	O.VLR_DESC_VERBA = ((VLR_TOT_BRUTO/QT_IT)*(PERC_DESC_VERBA/100)) 
FROM
	#RSVENDASORCAMENTO O 
WHERE
	O.VLR_DESC_VERBA = 0
	AND O.PERC_DESC_VERBA>0

UPDATE
	O
SET 
	O.VLR_DESC = CASE WHEN (VLR_DESC-VLR_DESC_VERBA) < 0 THEN 0 ELSE (VLR_DESC-VLR_DESC_VERBA) END
FROM
	#RSVENDASORCAMENTO O 
WHERE
	O.VLR_DESC_VERBA > 0

UPDATE
	O
SET 
	O.NM_FUN_LIB = FP_FUNC.NM_FUN,
	O.DS_CARGO_LIB=DS_CARGO
FROM
	#RSVENDASORCAMENTO O INNER JOIN FP_FUNC ON
	O.CD_EMP = FP_FUNC.CD_EMP AND
	O.CD_VEND_LIB = FP_FUNC.CD_FUN
	INNER JOIN FP_CARGO ON 
	FP_FUNC.CD_EMP = FP_CARGO.CD_EMP AND
	FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
WHERE
	O.CD_VEND_LIB > 0


UPDATE
	O
SET 
	O.NM_FUN_VERBA = FP_FUNC.NM_FUN,
	O.DS_CARGO_VERBA=DS_CARGO
FROM
	#RSVENDASORCAMENTO O INNER JOIN FP_FUNC ON
	O.CD_EMP = FP_FUNC.CD_EMP AND
	O.CD_VEND_VERBA = FP_FUNC.CD_FUN
	INNER JOIN FP_CARGO ON 
	FP_FUNC.CD_EMP = FP_CARGO.CD_EMP AND
	FP_FUNC.CD_CARGO = FP_CARGO.CD_CARGO
WHERE
	O.CD_VEND_VERBA > 0
	AND (VLR_DESC_VERBA+PERC_DESC_VERBA)>0

UPDATE
	O
SET 
	O.NR_ECF = PDV_VD.NR_ECF,
	O.CD_CX=PDV_VD.CD_CX
FROM
	#RSVENDASORCAMENTO O INNER JOIN PDV_VD_EST_ORC ON
	O.CD_EMP = PDV_VD_EST_ORC.CD_EMP AND
	O.CD_FILIAL = PDV_VD_EST_ORC.CD_FILIAL AND 
	O.CD_ORC = PDV_VD_EST_ORC.CD_ORC 
	INNER JOIN PDV_VD ON
	PDV_VD_EST_ORC.CD_EMP = PDV_VD.CD_EMP AND
	PDV_VD_EST_ORC.CD_FILIAL = PDV_VD.CD_FILIAL AND
	PDV_VD_EST_ORC.CD_VD = PDV_VD.CD_VD 

UPDATE
	O
SET 
	O.NM_CONCORRENTE = GLB_CONCORRENCIA.DS_CONCOR,
	O.VLR_ITEM_CONCORRENTE=EST_ORC_CPL_CONCOR.VLR_CONCOR,
	O.PERC_DESC_CONCORRENTE=EST_ORC_CPL_CONCOR.PERC_DESC
FROM
	#RSVENDASORCAMENTO O INNER JOIN EST_ORC_CPL_CONCOR ON
	O.CD_EMP = EST_ORC_CPL_CONCOR.CD_EMP AND
	O.CD_FILIAL = EST_ORC_CPL_CONCOR.CD_FILIAL AND 
	O.CD_ORC = EST_ORC_CPL_CONCOR.NR_ORC AND
	O.CD_IT = EST_ORC_CPL_CONCOR.CD_IT AND
	O.CD_PROD = EST_ORC_CPL_CONCOR.CD_PROD 
	INNER JOIN GLB_CONCORRENCIA ON 
	EST_ORC_CPL_CONCOR.CD_EMP = GLB_CONCORRENCIA.CD_EMP AND
	EST_ORC_CPL_CONCOR.CD_CONCOR = GLB_CONCORRENCIA.CD_CONCOR

select
	*
from
	#RsVendasOrcamento
ORDER BY
	CD_FILIAL,
	CD_ORC

DROP TABLE #RsVendasOrcamento;
DROP TABLE #RsFilial;
